/*! Hammer.JS - v1.0.6 - 2014-01-02
 * http://eightmedia.github.com/hammer.js
 *
 * Copyright (c) 2014 Jorik Tangelder <j.tangelder@gmail.com>;
 * Licensed under the MIT license */
!function(t,e){"use strict";var n=function(t,e){return new n.Instance(t,e||{})};n.defaults={stop_browser_behavior:{userSelect:"none",touchAction:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},n.HAS_POINTEREVENTS=t.navigator.pointerEnabled||t.navigator.msPointerEnabled,n.HAS_TOUCHEVENTS="ontouchstart"in t,n.MOBILE_REGEX=/mobile|tablet|ip(ad|hone|od)|android|silk/i,n.NO_MOUSEEVENTS=n.HAS_TOUCHEVENTS&&t.navigator.userAgent.match(n.MOBILE_REGEX),n.EVENT_TYPES={},n.DIRECTION_DOWN="down",n.DIRECTION_LEFT="left",n.DIRECTION_UP="up",n.DIRECTION_RIGHT="right",n.POINTER_MOUSE="mouse",n.POINTER_TOUCH="touch",n.POINTER_PEN="pen",n.EVENT_START="start",n.EVENT_MOVE="move",n.EVENT_END="end",n.DOCUMENT=t.document,n.plugins=n.plugins||{},n.gestures=n.gestures||{},n.READY=!1,n.utils={extend:function(t,n,i){for(var r in n)t[r]!==e&&i||(t[r]=n[r]);return t},each:function(t,n,i){var r,o;if("forEach"in t)t.forEach(n,i);else if(t.length!==e){for(r=0,o=t.length;o>r;r++)if(!1===n.call(i,t[r],r,t))return}else for(r in t)if(t.hasOwnProperty(r)&&!1===n.call(i,t[r],r,t))return},hasParent:function(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1},getCenter:function(t){var e=[],i=[];return n.utils.each(t,(function(t){e.push(void 0!==t.clientX?t.clientX:t.pageX),i.push(void 0!==t.clientY?t.clientY:t.pageY)})),{pageX:(Math.min.apply(Math,e)+Math.max.apply(Math,e))/2,pageY:(Math.min.apply(Math,i)+Math.max.apply(Math,i))/2}},getVelocity:function(t,e,n){return{x:Math.abs(e/t)||0,y:Math.abs(n/t)||0}},getAngle:function(t,e){var n=e.pageY-t.pageY,i=e.pageX-t.pageX;return 180*Math.atan2(n,i)/Math.PI},getDirection:function(t,e){return Math.abs(t.pageX-e.pageX)>=Math.abs(t.pageY-e.pageY)?t.pageX-e.pageX>0?n.DIRECTION_LEFT:n.DIRECTION_RIGHT:t.pageY-e.pageY>0?n.DIRECTION_UP:n.DIRECTION_DOWN},getDistance:function(t,e){var n=e.pageX-t.pageX,i=e.pageY-t.pageY;return Math.sqrt(n*n+i*i)},getScale:function(t,e){return t.length>=2&&e.length>=2?this.getDistance(e[0],e[1])/this.getDistance(t[0],t[1]):1},getRotation:function(t,e){return t.length>=2&&e.length>=2?this.getAngle(e[1],e[0])-this.getAngle(t[1],t[0]):0},isVertical:function(t){return t==n.DIRECTION_UP||t==n.DIRECTION_DOWN},stopDefaultBrowserBehavior:function(t,e){e&&t&&t.style&&(n.utils.each(["webkit","khtml","moz","Moz","ms","o",""],(function(i){n.utils.each(e,(function(e){i&&(e=i+e.substring(0,1).toUpperCase()+e.substring(1)),e in t.style&&(t.style[e]=e)}))})),"none"==e.userSelect&&(t.onselectstart=function(){return!1}),"none"==e.userDrag&&(t.ondragstart=function(){return!1}))}},n.Instance=function(t,e){var i=this;return n.READY||(n.event.determineEventTypes(),n.utils.each(n.gestures,(function(t){n.detection.register(t)})),n.event.onTouch(n.DOCUMENT,n.EVENT_MOVE,n.detection.detect),n.event.onTouch(n.DOCUMENT,n.EVENT_END,n.detection.detect),n.READY=!0),this.element=t,this.enabled=!0,this.options=n.utils.extend(n.utils.extend({},n.defaults),e||{}),this.options.stop_browser_behavior&&n.utils.stopDefaultBrowserBehavior(this.element,this.options.stop_browser_behavior),n.event.onTouch(t,n.EVENT_START,(function(t){i.enabled&&n.detection.startDetect(i,t)})),this},n.Instance.prototype={on:function(t,e){var i=t.split(" ");return n.utils.each(i,(function(t){this.element.addEventListener(t,e,!1)}),this),this},off:function(t,e){var i=t.split(" ");return n.utils.each(i,(function(t){this.element.removeEventListener(t,e,!1)}),this),this},trigger:function(t,e){e||(e={});var i=n.DOCUMENT.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e;var r=this.element;return n.utils.hasParent(e.target,r)&&(r=e.target),r.dispatchEvent(i),this},enable:function(t){return this.enabled=t,this}};var i=null,r=!1,o=!1;n.event={bindDom:function(t,e,i){var r=e.split(" ");n.utils.each(r,(function(e){t.addEventListener(e,i,!1)}))},onTouch:function(t,e,s){var a=this;this.bindDom(t,n.EVENT_TYPES[e],(function(c){var u=c.type.toLowerCase();if(!u.match(/mouse/)||!o){u.match(/touch/)||u.match(/pointerdown/)||u.match(/mouse/)&&1===c.which?r=!0:u.match(/mouse/)&&!c.which&&(r=!1),u.match(/touch|pointer/)&&(o=!0);var h=0;r&&(n.HAS_POINTEREVENTS&&e!=n.EVENT_END?h=n.PointerEvent.updatePointer(e,c):u.match(/touch/)?h=c.touches.length:o||(h=u.match(/up/)?0:1),h>0&&e==n.EVENT_END?e=n.EVENT_MOVE:h||(e=n.EVENT_END),(h||null===i)&&(i=c),s.call(n.detection,a.collectEventData(t,e,a.getTouchList(i,e),c)),n.HAS_POINTEREVENTS&&e==n.EVENT_END&&(h=n.PointerEvent.updatePointer(e,c))),h||(i=null,r=!1,o=!1,n.PointerEvent.reset())}}))},determineEventTypes:function(){var t;t=n.HAS_POINTEREVENTS?n.PointerEvent.getEvents():n.NO_MOUSEEVENTS?["touchstart","touchmove","touchend touchcancel"]:["touchstart mousedown","touchmove mousemove","touchend touchcancel mouseup"],n.EVENT_TYPES[n.EVENT_START]=t[0],n.EVENT_TYPES[n.EVENT_MOVE]=t[1],n.EVENT_TYPES[n.EVENT_END]=t[2]},getTouchList:function(t){return n.HAS_POINTEREVENTS?n.PointerEvent.getTouchList():t.touches?t.touches:(t.identifier=1,[t])},collectEventData:function(t,e,i,r){var o=n.POINTER_TOUCH;return(r.type.match(/mouse/)||n.PointerEvent.matchType(n.POINTER_MOUSE,r))&&(o=n.POINTER_MOUSE),{center:n.utils.getCenter(i),timeStamp:(new Date).getTime(),target:r.target,touches:i,eventType:e,pointerType:o,srcEvent:r,preventDefault:function(){this.srcEvent.preventManipulation&&this.srcEvent.preventManipulation(),this.srcEvent.preventDefault&&this.srcEvent.preventDefault()},stopPropagation:function(){this.srcEvent.stopPropagation()},stopDetect:function(){return n.detection.stopDetect()}}}},n.PointerEvent={pointers:{},getTouchList:function(){var t=[];return n.utils.each(this.pointers,(function(e){t.push(e)})),t},updatePointer:function(t,e){return t==n.EVENT_END?this.pointers={}:(e.identifier=e.pointerId,this.pointers[e.pointerId]=e),Object.keys(this.pointers).length},matchType:function(t,e){if(!e.pointerType)return!1;var i=e.pointerType,r={};return r[n.POINTER_MOUSE]=i===e.MSPOINTER_TYPE_MOUSE||i===n.POINTER_MOUSE,r[n.POINTER_TOUCH]=i===e.MSPOINTER_TYPE_TOUCH||i===n.POINTER_TOUCH,r[n.POINTER_PEN]=i===e.MSPOINTER_TYPE_PEN||i===n.POINTER_PEN,r[t]},getEvents:function(){return["pointerdown MSPointerDown","pointermove MSPointerMove","pointerup pointercancel MSPointerUp MSPointerCancel"]},reset:function(){this.pointers={}}},n.detection={gestures:[],current:null,previous:null,stopped:!1,startDetect:function(t,e){this.current||(this.stopped=!1,this.current={inst:t,startEvent:n.utils.extend({},e),lastEvent:!1,name:""},this.detect(e))},detect:function(t){if(this.current&&!this.stopped){t=this.extendEventData(t);var e=this.current.inst.options;return n.utils.each(this.gestures,(function(n){return this.stopped||!1===e[n.name]||!1!==n.handler.call(n,t,this.current.inst)?void 0:(this.stopDetect(),!1)}),this),this.current&&(this.current.lastEvent=t),t.eventType==n.EVENT_END&&!t.touches.length-1&&this.stopDetect(),t}},stopDetect:function(){this.previous=n.utils.extend({},this.current),this.current=null,this.stopped=!0},extendEventData:function(t){var e=this.current.startEvent;!e||t.touches.length==e.touches.length&&t.touches!==e.touches||(e.touches=[],n.utils.each(t.touches,(function(t){e.touches.push(n.utils.extend({},t))})));var i,r,o=t.timeStamp-e.timeStamp,s=t.center.pageX-e.center.pageX,a=t.center.pageY-e.center.pageY,c=n.utils.getVelocity(o,s,a);return"end"===t.eventType?(i=this.current.lastEvent&&this.current.lastEvent.interimAngle,r=this.current.lastEvent&&this.current.lastEvent.interimDirection):(i=this.current.lastEvent&&n.utils.getAngle(this.current.lastEvent.center,t.center),r=this.current.lastEvent&&n.utils.getDirection(this.current.lastEvent.center,t.center)),n.utils.extend(t,{deltaTime:o,deltaX:s,deltaY:a,velocityX:c.x,velocityY:c.y,distance:n.utils.getDistance(e.center,t.center),angle:n.utils.getAngle(e.center,t.center),interimAngle:i,direction:n.utils.getDirection(e.center,t.center),interimDirection:r,scale:n.utils.getScale(e.touches,t.touches),rotation:n.utils.getRotation(e.touches,t.touches),startEvent:e}),t},register:function(t){var i=t.defaults||{};return i[t.name]===e&&(i[t.name]=!0),n.utils.extend(n.defaults,i,!0),t.index=t.index||1e3,this.gestures.push(t),this.gestures.sort((function(t,e){return t.index<e.index?-1:t.index>e.index?1:0})),this.gestures}},n.gestures.Drag={name:"drag",index:50,defaults:{drag_min_distance:10,correct_for_drag_min_distance:!0,drag_max_touches:1,drag_block_horizontal:!1,drag_block_vertical:!1,drag_lock_to_axis:!1,drag_lock_min_distance:25},triggered:!1,handler:function(t,e){if(n.detection.current.name!=this.name&&this.triggered)return e.trigger(this.name+"end",t),void(this.triggered=!1);if(!(e.options.drag_max_touches>0&&t.touches.length>e.options.drag_max_touches))switch(t.eventType){case n.EVENT_START:this.triggered=!1;break;case n.EVENT_MOVE:if(t.distance<e.options.drag_min_distance&&n.detection.current.name!=this.name)return;if(n.detection.current.name!=this.name&&(n.detection.current.name=this.name,e.options.correct_for_drag_min_distance&&t.distance>0)){var i=Math.abs(e.options.drag_min_distance/t.distance);n.detection.current.startEvent.center.pageX+=t.deltaX*i,n.detection.current.startEvent.center.pageY+=t.deltaY*i,t=n.detection.extendEventData(t)}(n.detection.current.lastEvent.drag_locked_to_axis||e.options.drag_lock_to_axis&&e.options.drag_lock_min_distance<=t.distance)&&(t.drag_locked_to_axis=!0);var r=n.detection.current.lastEvent.direction;t.drag_locked_to_axis&&r!==t.direction&&(t.direction=n.utils.isVertical(r)?t.deltaY<0?n.DIRECTION_UP:n.DIRECTION_DOWN:t.deltaX<0?n.DIRECTION_LEFT:n.DIRECTION_RIGHT),this.triggered||(e.trigger(this.name+"start",t),this.triggered=!0),e.trigger(this.name,t),e.trigger(this.name+t.direction,t),(e.options.drag_block_vertical&&n.utils.isVertical(t.direction)||e.options.drag_block_horizontal&&!n.utils.isVertical(t.direction))&&t.preventDefault();break;case n.EVENT_END:this.triggered&&e.trigger(this.name+"end",t),this.triggered=!1}}},n.gestures.Hold={name:"hold",index:10,defaults:{hold_timeout:500,hold_threshold:1},timer:null,handler:function(t,e){switch(t.eventType){case n.EVENT_START:clearTimeout(this.timer),n.detection.current.name=this.name,this.timer=setTimeout((function(){"hold"==n.detection.current.name&&e.trigger("hold",t)}),e.options.hold_timeout);break;case n.EVENT_MOVE:t.distance>e.options.hold_threshold&&clearTimeout(this.timer);break;case n.EVENT_END:clearTimeout(this.timer)}}},n.gestures.Release={name:"release",index:1/0,handler:function(t,e){t.eventType==n.EVENT_END&&e.trigger(this.name,t)}},n.gestures.Swipe={name:"swipe",index:40,defaults:{swipe_min_touches:1,swipe_max_touches:1,swipe_velocity:.7},handler:function(t,e){if(t.eventType==n.EVENT_END){if(e.options.swipe_max_touches>0&&t.touches.length<e.options.swipe_min_touches&&t.touches.length>e.options.swipe_max_touches)return;(t.velocityX>e.options.swipe_velocity||t.velocityY>e.options.swipe_velocity)&&(e.trigger(this.name,t),e.trigger(this.name+t.direction,t))}}},n.gestures.Tap={name:"tap",index:100,defaults:{tap_max_touchtime:250,tap_max_distance:10,tap_always:!0,doubletap_distance:20,doubletap_interval:300},handler:function(t,e){if(t.eventType==n.EVENT_END&&"touchcancel"!=t.srcEvent.type){var i=n.detection.previous,r=!1;if(t.deltaTime>e.options.tap_max_touchtime||t.distance>e.options.tap_max_distance)return;i&&"tap"==i.name&&t.timeStamp-i.lastEvent.timeStamp<e.options.doubletap_interval&&t.distance<e.options.doubletap_distance&&(e.trigger("doubletap",t),r=!0),(!r||e.options.tap_always)&&(n.detection.current.name="tap",e.trigger(n.detection.current.name,t))}}},n.gestures.Touch={name:"touch",index:-1/0,defaults:{prevent_default:!1,prevent_mouseevents:!1},handler:function(t,e){return e.options.prevent_mouseevents&&t.pointerType==n.POINTER_MOUSE?void t.stopDetect():(e.options.prevent_default&&t.preventDefault(),void(t.eventType==n.EVENT_START&&e.trigger(this.name,t)))}},n.gestures.Transform={name:"transform",index:45,defaults:{transform_min_scale:.01,transform_min_rotation:1,transform_always_block:!1},triggered:!1,handler:function(t,e){if(n.detection.current.name!=this.name&&this.triggered)return e.trigger(this.name+"end",t),void(this.triggered=!1);if(!(t.touches.length<2))switch(e.options.transform_always_block&&t.preventDefault(),t.eventType){case n.EVENT_START:this.triggered=!1;break;case n.EVENT_MOVE:var i=Math.abs(1-t.scale),r=Math.abs(t.rotation);if(i<e.options.transform_min_scale&&r<e.options.transform_min_rotation)return;n.detection.current.name=this.name,this.triggered||(e.trigger(this.name+"start",t),this.triggered=!0),e.trigger(this.name,t),r>e.options.transform_min_rotation&&e.trigger("rotate",t),i>e.options.transform_min_scale&&(e.trigger("pinch",t),e.trigger("pinch"+(t.scale<1?"in":"out"),t));break;case n.EVENT_END:this.triggered&&e.trigger(this.name+"end",t),this.triggered=!1}}},"function"==typeof define&&"object"==typeof define.amd&&define.amd?define((function(){return n})):"object"==typeof module&&"object"==typeof module.exports?module.exports=n:t.Hammer=n}(this);
